module RPG
  class Item
    def initialize
      @id = 0
      @name = ""
      @icon_name = ""
      @description = ""
      @scope = 0
      @occasion = 0
      @animation1_id = 0
      @animation2_id = 0
      @menu_se = RPG::AudioFile.new("", 80)
      @common_event_id = 0
      @price = 0
      @consumable = true
      @parameter_type = 0
      @parameter_points = 0
      @recover_hp_rate = 0
      @recover_hp = 0
      @recover_sp_rate = 0
      @recover_sp = 0
      @hit = 100
      @pdef_f = 0
      @mdef_f = 0
      @variance = 0
      @element_set = []
      @plus_state_set = []
      @minus_state_set = []
    end
    attr_accessor :id
    attr_accessor :name
    attr_accessor :icon_name
    attr_accessor :description
    attr_accessor :scope
    attr_accessor :occasion
    attr_accessor :animation1_id
    attr_accessor :animation2_id
    attr_accessor :menu_se
    attr_accessor :common_event_id
    attr_accessor :price
    attr_accessor :consumable
    attr_accessor :parameter_type
    attr_accessor :parameter_points
    attr_accessor :recover_hp_rate
    attr_accessor :recover_hp
    attr_accessor :recover_sp_rate
    attr_accessor :recover_sp
    attr_accessor :hit
    attr_accessor :pdef_f
    attr_accessor :mdef_f
    attr_accessor :variance
    attr_accessor :element_set
    attr_accessor :plus_state_set
    attr_accessor :minus_state_set
  
  
  
  

    ###########################################
    # Ajouts aux classes
    ###########################################

    def to_dmk
      my = My_RPG::My_Item.new

      my.id = @id
      my.name = @name
      my.icon_name = @icon_name
      my.description = @description
      my.scope = @scope
      my.occasion = @occasion
      my.animation1_id = @animation1_id
      my.animation2_id = @animation2_id
      my.menu_se = @menu_se
      my.common_event_id = @common_event_id
      my.price = @price
      my.consumable = @consumable
      my.parameter_type = @parameter_type
      my.parameter_points = @parameter_points
      my.recover_hp_rate = @recover_hp_rate
      my.recover_hp = @recover_hp
      my.recover_sp_rate = @recover_sp_rate
      my.recover_sp = @recover_sp
      my.hit = @hit
      my.pdef_f = @pdef_f
      my.mdef_f = @mdef_f
      my.variance = @variance
      my.element_set = @element_set
      my.plus_state_set = @plus_state_set
      my.minus_state_set = @minus_state_set
      
      

      return my
    end



    def comparer(other)
      
      list_self = [
        @id,
        @name,
        @icon_name,
        @description,
        @scope,
        @occasion,
        @animation1_id,
        @animation2_id,
        @common_event_id,
        @price,
        @consumable,
        @parameter_type,
        @parameter_points,
        @recover_hp_rate,
        @recover_hp,
        @recover_sp_rate,
        @recover_sp,
        @hit,
        @pdef_f,
        @mdef_f,
        @variance,
        @element_set,
        @plus_state_set,
        @minus_state_set
      ]

      list_other = [
        other.id,
        other.name,
        other.icon_name,
        other.description,
        other.scope,
        other.occasion,
        other.animation1_id,
        other.animation2_id,
        other.common_event_id,
        other.price,
        other.consumable,
        other.parameter_type,
        other.parameter_points,
        other.recover_hp_rate,
        other.recover_hp,
        other.recover_sp_rate,
        other.recover_sp,
        other.hit,
        other.pdef_f,
        other.mdef_f,
        other.variance,
        other.element_set,
        other.plus_state_set,
        other.minus_state_set
      ]

      
      if list_self != list_other
        raise(DMKW_DMK_Diff.new("item.parameters"))
      end

      if @menu_se.comparer(other.menu_se) == false
        raise(DMKW_DMK_Diff.new("item.menu_se"))
      end
      
      


      return true
    end

  end
end
